### Name: DEoptim
### Title: Differential Evolution Optimization
### Aliases: DEoptim
### Keywords: nonlinear optimize

### ** Examples

  ## Rosenbrock Banana function
  Rosenbrock <- function(x){
  x1 <- x[1]
  x2 <- x[2]
  100 * (x2 - x1 * x1)^2 + (1 - x1)^2
  }

  lower <- c(-10,-10)
  upper <- -lower
  DEoptim(Rosenbrock, lower, upper)
  DEoptim(Rosenbrock, lower, upper, 
    control = list(NP = 100, refresh = 1))
  DEoptim(Rosenbrock, lower, upper, 
    control = list(NP = 50, itermax = 200, F = 1.5, 
    CR = 0.2, refresh = 1))
  DEoptim(Rosenbrock, lower, upper,
    control = list(NP = 80, itermax = 400, F = 1.2,
    CR = 0.7, refresh = 1))

  ## 'Wild' function, global minimum at about -15.81515
  Wild <- function(x)
    10 * sin(0.3*x) * sin(1.3*x^2) + 
       0.00001 * x^4 + 0.2 * x + 80
  plot(Wild, -50, 50, n = 1000, 
    main = "DEoptim minimizing 'Wild function'")
  DEoptim(Wild, lower = -50, upper = 50,
      control = list(NP = 50, refresh = 1))



