resample.ls              package:Davies              R Documentation

_P_a_r_a_m_e_t_r_i_c _r_e_s_a_m_p_l_i_n_g _f_r_o_m _a _D_a_v_i_e_s _d_i_s_t_r_i_b_u_t_i_o_n

_D_e_s_c_r_i_p_t_i_o_n:

     Carries out parametric resampling on the null of the dataset being
     drawn from a Davies distribution

_U_s_a_g_e:

     resample.ls(data, n = 99)

_A_r_g_u_m_e_n_t_s:

    data: dataset to be resampled

       n: number of trials to be carried out

_D_e_t_a_i_l_s:

     Carries out parametric resampling.  Essentially fits a Davies
     distribution to 'data', determines an error for this set of
     parameters, then draws n `ghost' datasets drawn from a Davies
     distribution with this set of optimized parameters.  Comparing the
     original error with the distribution of `ghost' errors allows one
     to assess how close to a Davies distribution the original dataset
     ('data') was.

_V_a_l_u_e:

     Returns as list with three components: 

  errors: A vector of length 'n' corresponding to the `ghost' errors

statistic: Error of the original dataset from the optimal fit Davies
          distribution

 p-value: The p-value of this.  Will be 'runif()' if 'data' is in fact
          drawn from a Davies distribution

_A_u_t_h_o_r(_s):

     Robin K. S. Hankin

_R_e_f_e_r_e_n_c_e_s:

     W. H. Press and others, Numerical recipes: the art of scientific
     computing, 1989, Cambridge University Press

_E_x_a_m_p_l_e_s:

     hist(resample.ls(rnorm(50)^2)$errors)
     fit.davies.q(resample.ls(rnorm(80)^2)$errors)

