HTMLapplets.plot         package:HTMLapplets         R Documentation

_H_T_M_L_a_p_p_l_e_t_s._p_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     Create a dynamic 2D scatterplot in an R2HTML document. Undesired
     effects might occur if several plots are put into a single HTML
     document. The applet used is a customised version of PtPlot
     (http://ptolemy.eecs.berkeley.edu/).

_U_s_a_g_e:

     HTMLapplets.plot(x, y = NULL,
                 file = .HTML.file, append = TRUE,
                 id = "plotml",
                 plot = TRUE, data.link = TRUE, center=TRUE, help=FALSE,
                 width = 500, height = 400, background ="ffffff",
                 codebase = ".", archive = "plotmlapplethb8.jar",
                 copy.jar = TRUE, overwrite.jar=TRUE,
                 ...)

_A_r_g_u_m_e_n_t_s:

       x: the coordinates of points in the plot.

       y: the coordinates of points in the plot.

    file: HTML target output file.

  append: if TRUE output will be appended to 'file' otherwise it will
          overwrite the content of the file.

      id: plot identifier.

    plot: if TRUE, the plotML file is created

data.link: add a link to the plotML file in the HTML file

  center: center the output in the HTML document

    help: print a help message in the HTML file

   width: applet width

  height: applet height

background: background colour of the plot (no "#" allowed)

codebase: codebase parameter for the applet tag. If the jar files are
          in a specific directory (e.g. HTTPDIR/runtime/jar/), set the
          codebase parameter accordingly (e.g. "/runtime/jar") and set
          the parameter copy.jar to FALSE.

 archive: name of the jar file.

copy.jar: if TRUE (default) the jar file is copied to the HTML target
          directory

overwrite.jar: if TRUE (default) replace the jar file if it exists.

     ...: 'plotML' parameters

_V_a_l_u_e:

_R_e_f_e_r_e_n_c_e_s:

_S_e_e _A_l_s_o:

     'plot', 'HTML'

_E_x_a_m_p_l_e_s:

     data(ChickWeight)

     l <- split(ChickWeight[,c("Time","weight")], ChickWeight$Chick)
     for(i in 1:length(l)) names(l[[i]]) <- c("Time",paste("Chick",i,sep=""))
     chicks <- data.frame(Time=sort(unique(ChickWeight$Time)))
     for(i in 1:length(l))
       chicks <- merge(chicks,l[[i]], all=TRUE)
     mean <- apply(chicks,1,mean, na.rm=TRUE)
     sd <- apply(chicks,1,sd, na.rm=TRUE)

     cat("CREATING \"./chicksPlot.html\"\n")

     # first plot
     HTMLInitFile("./","chicksPlot1")
     HTML.title("HTMLapplets")
     HTMLapplets.plot(id="all",
                 x=chicks$Time,
                 y=chicks[,2:10],
                 xlab="time", ylab="Weight", main="Test1",
                 xlim=c(8,13), ylim=c(50,100),
                 type="l", pch=1, height=250, help=TRUE)
     HTMLEndFile()
     # second plot
     HTMLInitFile("./","chicksPlot2")
     HTML.title("HTMLapplets")
     HTMLapplets.plot(id="summary",
                 x=chicks$Time,
                 y=mean,
                 xlab="time", ylab="Weight", type="l", main="Test2",
                 pch=1, height=250, background="e0e0e0",
                 data.link=FALSE,
                 diameter=round(mean/max(mean)*20+1),
                 col=gsub("#","",rgb(1-mean/max(mean),0,mean/max(mean))),
                 low.error=mean-sd, high.error=mean+sd)
     HTMLEndFile()

