make.T              package:LoopAnalyst              R Documentation

_C_o_m_p_u_t_e _t_h_e _A_b_s_o_l_u_t_e _F_e_e_d_b_a_c_k _M_a_t_r_i_x _o_f _a _C_o_m_m_u_n_i_t_y _M_a_t_r_i_x

_D_e_s_c_r_i_p_t_i_o_n:

     Validates a community matrix and computes its absolute feedback
     matrix.

_U_s_a_g_e:

     make.T(CM, status=FALSE)

_A_r_g_u_m_e_n_t_s:

      CM: A valid community matrix.

  status: Switches on an element-by-element progress indicator when set
          to 'TRUE'. Set to 'FALSE' by default.

_D_e_t_a_i_l_s:

     The supplied matrix is validated as a community matrix, and its
     absolute feedback matrix is computed.  The value of a given
     element indicates the total number of disjoint cycles spanning all
     varibles of the complementary subsystem for each path from j to i.
      Values of a given element may be positive or zero, and bounds the
     magnitude of the associated adjoint matrix of the negative
     community matrix. 
      NOTE: weighted feedback, adjoint and absolute feeback matrices
     are transposed relative to the community effect matrix.

_V_a_l_u_e:

     The absolute feedback matrix for a community matrix

_A_u_t_h_o_r(_s):

     Alexis Dinno <URL: http://www.doyenne.com/LoopAnalyst/>

_R_e_f_e_r_e_n_c_e_s:

     Dambacher, J. M., et al. (2003) Qualitative stability and
     ambiguity in model ecosystems. _The American Naturalist_,
     *161(6)*,876-888

     Dambacher, J. M. and Li, H. W. and Rossignol, P. A. (2002)
     Relevance of community structure in assessing indeterminacy of
     ecological predictions. _Ecology_, *83(5)*,1372-1385

_S_e_e _A_l_s_o:

     'make.cem, make.wfm, make.adjoint and weighted.predictions'.

_E_x_a_m_p_l_e_s:

     ## compute T for a community matrix
     data(cm.dambacher)
     make.T(cm.dambacher)

