### Name: lee
### Title: Two-Phase Half-Life Estimation by Linear Fitting
### Aliases: lee
### Keywords: misc

### ** Examples


## example for preparation 1 from Lee et. al (1990)
time <- c(0.5, 1.0, 4.0, 8.0, 12.0, 24.0)
conc <- c(75, 72, 61, 54, 36, 6)
result1 <- lee(conc=conc, time=time, method='ols', points=2, longer.terminal=TRUE)
print(result1$parms)
plot(result1)
plot(result1, log='y')

## example for preparation 1 from Lee et. al (1990)
time <- c(0.5, 1.0, 4.0, 8.0, 12.0, 24.0)
conc <- c(75, 72, 61, 54, 36, 6)
result2 <- lee(conc=conc, time=time, method='ols', points=2, longer.terminal=FALSE)
print(result2$parms)
plot(result2)
plot(result2, log='y')

## example for preparation 2 from Lee et. al (1990)
time <- c(0.5, 1.0, 2.0, 6.5, 8.0, 12.5, 24.0)
conc <- c(75, 55, 48, 51, 39, 9, 5)
result3 <- lee(conc=conc, time=time, method='ols', points=2, longer.terminal=FALSE)
print(result3$parms)
plot(result3)
plot(result3, log='y')

## advanced plots 
xlim <- c(0,30)
ylim <- c(1,80)
ylab <- 'Log Concentration'
xlab <- 'Time [hours]'

text1 <- paste('Initial half-life:', round(result2$parms[1,1],2), 
'   Terminal half-life:', round(result2$parms[1,2],2))
text2 <- paste('Initial half-life:', round(result3$parms[1,1],2), 
'   Terminal half-life:', round(result3$parms[1,2],2))

split.screen(figs=c(2,1)) 
screen(1)
plot(result2, ylab=ylab, xlab=xlab, main='Half-life: Preparation 1', 
xlim=xlim, ylim=ylim, log='y', sub=text1)
screen(2)
plot(result3, ylab=ylab, xlab=xlab, main='Half-life: Preparation 2', 
xlim=xlim, ylim=ylim, log='y', sub=text2)
close.screen(all=TRUE)



