### Name: pretty.string
### Title: Separate a very long vector of strings on several rows
### Aliases: pretty.string
### Keywords: misc

### ** Examples

set.seed(1234)
long.string <- paste("This would be a very long string, composed from the following words:", 
                     paste(sample(c("one", "two", "three"), 60, replace=TRUE), collapse=" "))

long.string

string.vector <- unlist(strsplit(long.string, " "))

# a row length of 70, no space at the beginning
cat(pretty.string(string.vector, 70, 0, " "), "\n")

# a row length of 50, inserting 7 spaces before each row
cat("      ", pretty.string(string.vector, 50, 7, " "), "\n")




