### Name: qmcc
### Title: Find a minimum solution in a boolean procedure, using the
###   Quine-McCluskey algorithm
### Aliases: qmcc
### Keywords: misc

### ** Examples

data(Osa)

# find a solution using the Quine-McCluskey (qmcc) algorithm
# explaining only the presence of the outcome
qmcc(Osa, outcome="OUT", expl.1=TRUE)

# now including the remainers and the contradictions
qmcc(Osa, outcome="OUT", expl.1=TRUE, incl.rem=TRUE, incl.ctr=TRUE)

# the same as above, but we want to see the prime implicants chart
qmcc(Osa, outcome="OUT", expl.1=TRUE, incl.rem=TRUE, incl.ctr=TRUE, chart=TRUE)

# even more details
qmcc(Osa, outcome="OUT", expl.1=TRUE, incl.rem=TRUE, incl.ctr=TRUE, details=TRUE)

# printing the lines corresponding to each prime implicant
qmcc(Osa, outcome="OUT", expl.1=TRUE, incl.rem=TRUE, incl.ctr=TRUE, show.lines=TRUE)

# now explaining the absence of the outcome
qmcc(Osa, outcome="OUT", expl.0=TRUE, incl.rem=TRUE, incl.ctr=TRUE, show.lines=TRUE)




