### Name: writeMat
### Title: Writes a MAT file structure
### Aliases: writeMat.default writeMat
### Keywords: file IO

### ** Examples
A <- matrix(1:27, ncol=3)
B <- as.matrix(1:10)

filename <- paste(tempfile(), ".mat", sep="")

writeMat(filename, A=A, B=B)
data <- readMat(filename)
print(data)

unlink(filename)

## Not run: 
##D # When writing to a stream connection the receiver needs to know in
##D # beforehand how many bytes are available. This can be done by using
##D # the 'onWrite' argument.
##D onWrite <- function(x)
##D   writeBin(x$length, con=x$con, size=4, endian="little");
##D writeMat(con, A=A, B=B, onWrite=onWrite)
## End(Not run)



