### Name: extract.array
### Title: Extract a subset of an array, matrix or a vector with unknown
###   dimensions
### Aliases: extract.array extract.array extract.matrix extract.default
### Keywords: methods programming

### ** Examples

cat("\nCreate an array 'x' with a random number of dimensions:\n")
maxdim <- 4
dim <- sample(3:maxdim, size=sample(2:maxdim, size=1), replace=TRUE)
ndim <- length(dim)
dimnames <- list()
for (kk in 1:ndim)
  dimnames[[kk]] <- sprintf("%s%d", letters[kk], 1:dim[kk])
x <- 1:prod(dim)
x <- array(x, dim=dim, dimnames=dimnames)

cat("\nArray 'x':\n")
print(x)

cat("\nExtract 'x[2:3,...]':\n")
print(extract(x, "1"=2:3))

cat("\nExtract 'x[3,2:3,...]':\n")
print(extract(x, "1"=3,"2"=2:3))

cat("\nExtract 'x[...,2:3]':\n")
indices <- list(2:3)
names(indices) <- length(dim(x))
print(extract(x, indices=indices))



