### Name: AvgDailyGain
### Title: Average daily weight gain of steers on different diets
### Aliases: AvgDailyGain
### Keywords: datasets

### ** Examples

options(contrasts = c(unordered = "contr.SAS", ordered = "contr.poly"))
if (require("lattice", quietly = TRUE, character = TRUE)) {
  ## plot of adg versus Treatment by Block
  xyplot(adg ~ Treatment | Block, AvgDailyGain, type = c("g", "p", "r"),
         xlab = "Treatment (amount of feed additive)",
         ylab = "Average daily weight gain (lb.)", aspect = "xy",
         index.cond = function(x, y) coef(lm(y ~ x))[1])
}
# compare with output 5.1, p. 178
(fm1Adg <- lmer(adg ~ InitWt * Treatment - 1 + (1 | Block), AvgDailyGain))
anova(fm1Adg)   # checking significance of terms
(fm2Adg <- lmer(adg ~ InitWt + Treatment + (1 | Block), AvgDailyGain))
anova(fm2Adg)
summary(lmer(adg ~ InitWt + Treatment - 1 + (1 | Block), AvgDailyGain))



