### Name: Semi2
### Title: Oxide layer thicknesses on semiconductors
### Aliases: Semi2
### Keywords: datasets

### ** Examples

options(contrasts = c(unordered = "contr.SAS", ordered = "contr.poly"))
str(Semi2)
xtabs(~Lot + Wafer, Semi2)
Semi2$LotWafer <- with(Semi2, Lot:Wafer)
fm1Semi2 <- lmer(Thickness ~ 1 + (1|LotWafer) + (1|Lot), Semi2)
summary(fm1Semi2)       # compare with output 4.13, p. 156
fm2Semi2 <- lmer(Thickness ~ Source + (1|LotWafer) + (1|Lot), Semi2)
summary(fm2Semi2)       # compare with output 4.15, p. 159
anova(fm2Semi2)
Semi2$LotSrc <- with(Semi2, Lot:Source)
fm3Semi2 <- lmer(Thickness ~ Source + (1|LotWafer) + (1|LotSrc), Semi2)
summary(fm3Semi2)       # compare with output 4.17, p. 163
## This is not the same as the SAS model.



