### Name: Weights
### Title: Data from a weight-lifting program
### Aliases: Weights
### Keywords: datasets

### ** Examples

options(contrasts = c(unordered = "contr.SAS", ordered = "contr.poly"))
str(Weights)
fm1Weight <- lmer(strength ~ Program * Time + (1|Subj), Weights)
summary(fm1Weight)               # compare with output 3.1, p. 91
anova(fm1Weight)
fm2Weight <- lmer(strength ~ Program * Time + (Time|Subj), Weights)
anova(fm1Weight, fm2Weight)
summary(fm2Weight)
## Not run: 
##D intervals(fm2Weight)
##D fm3Weight <- update(fm2Weight, correlation = corAR1())
##D anova(fm2Weight, fm3Weight)
##D fm4Weight <- update(fm3Weight, strength ~ Program * (Time + I(Time^2)),
##D                     random = ~Time|Subj)
##D summary(fm4Weight)
##D anova(fm4Weight)
##D intervals(fm4Weight)
## End(Not run)



