### Name: calculate.horizons
### Title: Update of the horizon structure
### Aliases: calculate.horizons
### Keywords: spatial

### ** Examples


############ fetch the standard definition of a profile ###########
h <- xswms2d(xlim=c(1, 100), ylim=c(1, 100), step=1, new=NULL)
##        new=NULL: xswms2d returns the standard definition for h
##                       without entering the interactive surface

############ modify the profile definition ########################
h$n <- 2         ## define a second horizon
h$H2 <- h$H1    
h$H2$type <- "H" ## genuine horizon, not polygon
h$H2$model$model[[1]]$scale <- 30 ## different
## coordinates of the boundary segments between the horizons: 
h$H2$points <- list(x=seq(1, 100, 5))             ## x coordinates
h$H2$points$y <- 80 + 20 * cos(h$H2$points$x / 10) ## y coordinates
h <- calculate.horizons(h)       ## update the internal parameters
                         ## after modifying the profile definition
draw.horizons(h)                 ## plot the profile

############ simulate water flux for the specified profile ########
h <- simulateHorizons(h)        ## simulate stochastic components
plotRF(h)                        ##   plot the simulated random field
swms2d.out <- swms2d(h, iter.print=1) ## numerical simulation
if (is.character(swms2d.out)) {
  cat(swms2d.out, "\n")          ## an error has occured 
} else {                         
  plotWater(swms2d.out, what="theta") ## plot the water contents 
}




