### Name: create.waterflow
### Title: Preparation for swms2d
### Aliases: create.waterflow
### Keywords: spatial

### ** Examples

h <- xswms2d(xlim=c(1, 50), ylim=c(1, 30), step=1, new=NULL)
h$water$red <- 1
h$water$top.value <- -50   ## pressure head at surface
h$water$TPrint <- 10
h <- simulateHorizons(h)  ## simulation of the stochastic components
plotRF(h)
swms2d.in <- create.waterflow(h) ## rewrite h as a list readable by
##        swms2d; the following function can also directly be called 
##        with the argument h; then  create.waterflow is called
##        internally
str(swms2d.in)
swms2d.out <- swms2d(swms2d.in, iter.print=1) ## numerical simulation
if (is.character(swms2d.out)) cat(swms2d.out, "\n") else
plotWater(swms2d.out, what="H")



