### Name: modify.horizons
### Title: Stochastic variation of the definitions of the horizons
### Aliases: modify.horizons
### Keywords: spatial

### ** Examples

h <- xswms2d(xlim=c(1, 100), ylim=c(1, 100), step=1, new=NULL)
##        new=NULL: xswms2d returns the standard definition for h
##                          without entering the interactive surface
h$n <- 2         ## define a second horizon
h$H2 <- h$H1    
h$H2$type <- "H" ## genuine horizon, not polygon

## coordinates of the boundary segments between the horizons 
h$H2$points <- list(x=seq(1, 100, 5))             ## x coordinates
h$H2$points$y <- 40 + 20 * cos(h$H2$points$x / 5) ## y coordinates

h <- calculate.horizons(h) ## update the internal parameters
draw.horizons(h)           ## plot the horizons
for (i in 1:20) {
  readline("Press return")
  h <- modify.horizons(h)  ## stochastic modification of the horizons
  draw.horizons(h)        
  }



