### Name: risk.index
### Title: Risk index for soil leaching
### Aliases: risk.index
### Keywords: spatial

### ** Examples

sample.depth <- 1 : 100
d <- rexp(1000, 1/25)
freq <- numeric(length(sample.depth))
for (i in 1:length(sample.depth)) freq[i] <- sum(d>=sample.depth[i])
cr <- risk.index(cbind(sample.depth, freq),
                 selected.rate=c(0.95, 0.9), 
                 endpoint.tolerance=20,  method="fix.m")
cr$risk.index ## the true value is 0



