### Name: tortuosity
### Title: Variability of the tortuosity
### Aliases: tortuosity
### Keywords: spatial

### ** Examples

data(F04)
path <- paste(system.file(package='SoPhy'),"tracer", sep="/")
F04$name <- paste(path, "F04.G.tif", sep="/")
m <- analyse.profile(F04, estimate.all=FALSE, method="fix.m",
                     selected.rate=c(0, 0), selected.dist=NULL,
                     interactive=FALSE, Print=0)
stained <- m$fct(m$picture, m$param)
freq <- m$absfr
truedepth <- m$r.i$data[, 1] + ncol(stained) - m$loc[[1]]$y[2]
tol = 0

mt <- tortuosity(truedepth, freq,  range.depth=c(85, 97),
                 range.xi=c(-2.5, -0.6), Print=2, tol=tol)
str(mt$opt)

# fig. 3A in Schlather and Huwe (2005)
matplot(mt$xi, mt$raw.m, xlab=expression(xi), ylab="m",
        type="l", col=1, lty=1)     

# fig. 3B in Schlather and Huwe (2005)
plot(mt$xi, mt$span.m, xlab=expression(xi), ylab="span m",
     type="l", col=1, lty=1)
for (cex in c(9, 9.5, 10))
  points(mt$opt$x, mt$opt$mspan, cex=cex, col="darkgrey")

# fig. 2 in Schlather and Huwe (2005)
plot(mt$input$depth, mt$input$freq, xaxs="i", yaxs="i",
     pch=16, ylab="stained pixels", xlab="depth [pixels]",
     col="blue", cex=2)
lines(mt$fitted$depth, mt$fitted$p, lwd=3, col=2)



