### Name: xswms2d
### Title: Modelling of water flux and solute transport
### Aliases: sophy xswms2d
### Keywords: spatial

### ** Examples


## Not run: 
##D ### without underlying profile
##D h0 <- xswms2d(xlim=c(1, 100), ylim=c(1, 100), step=1)
##D # or, equivalently:
##D # h1 <- sophy(xlim=c(1, 100), ylim=c(1, 100), step=1)
##D 
##D ### underlying profile
##D ### the profile was taken by M. Flury, J. Leuenberger,
##D ### B. Studer, W.A. Jury and H. Fl\"uhler, see also URL
##D ### \url{http://www.ito.umnw.ethz.ch/SoilPhys/Fliessmuster/projekt_flury.html}
##D pic <- paste(system.file(package='SoPhy'), 'tracer', 'K06', sep="/")
##D h <- xswms2d(xlim=c(0,160), step=1, aniso=TRUE,
##D              update=FALSE, waterflow=FALSE, pict=pic)
##D 
##D ### repeated call
##D h <- xswms2d(h=h, update=TRUE, waterflow=TRUE)
##D 
##D ### an example for non-atmospheric root uptake
##D h <- sophy(xl=c(1,10), yl=c(1,10), step=0.1, new=NULL) ## get standard
##D h$root[[1]]$root.condition <- 1   ## dirichlet condition for roots
##D h$root[[1]]$root.uptake <- -200   ## value for dirichlet condition
##D h$root[[1]]$plants.lambda <- 0.07 ## intensity of plants
##D h$water$TPrint <- 2     ## end point of simulation (film lasts about 2 min)
##D h$water$red <- 1        ## precise simulation
##D h$water$breakpoint <- 3 ## high image frequency (close to a film)
##D h$water$top.bound <- 2  ## dirichlet
##D h$water$top.value <- -8 ## value on the boundary
##D h <- xswms2d(h=h, update=TRUE, waterflow=TRUE)
## End(Not run)

    




