### Name: SparseM.hb
### Title: Harwell-Boeing Format Sparse Matrices
### Aliases: SparseM.hb read.matrix.hb model.matrix,ANY-method
###   model.matrix,matrix.csc.hb-method model.matrix,matrix.ssc.hb-method
###   model.matrix.matrix.ssc.hb model.response,ANY-method
###   model.response,matrix.csc.hb-method
###   model.response,matrix.ssc.hb-method model.guess,matrix.csc.hb-method
###   model.guess,matrix.ssc.hb-method model.xexact,matrix.csc.hb-method
###   model.xexact,matrix.ssc.hb-method model.response model.guess
###   model.xexact model.matrix
### Keywords: IO

### ** Examples
 
read.matrix.hb(system.file("data","lsq.rra",package = "SparseM"))-> hb.o
class(hb.o) # -> [1] "matrix.csc.hb"
model.matrix(hb.o)->X
class(X) # -> "matrix.csr"
dim(X) # -> [1] 1850  712
y <- model.response(hb.o) # extract the rhs
length(y) # [1] 1850
read.matrix.hb(system.file("data","rua_32_ax.rua",package = "SparseM"))-> hb.o
X <- model.matrix(hb.o)
y <- model.response(hb.o) # extract the rhs
g <- model.guess(hb.o) # extract the guess 
a <- model.xexact(hb.o) # extract the xexact 
fit <- solve(t(X) %*% X, t(X) %*% y) # compare solution with xexact solution 



