### Name: bct
### Title: Box-Cox Transforms
### Aliases: bct
### Keywords: manip datagen regression

### ** Examples

y <- rlnorm(500, 3, 2)
par(mfrow=c(2,2))
qqnorm(y)
qqnorm(bct(y,1/2))
qqnorm(bct(y,0))
hist(bct(y,0))

## The function is currently defined as
function(y,lambda){

  gm <- exp( mean( log(y) ) )

  if(lambda==0) return( log(y)*gm )
  
  yt <- (y^lambda - 1)/( lambda * gm^(lambda-1) )
  return(yt)
  }



