### Name: tkBrush
### Title: Change the Color and Styles of points interactively
### Aliases: tkBrush
### Keywords: hplot iplot dynamic

### ** Examples

## Not run: 
##D 
##D # Iris dataset
##D 
##D out1 <- tkBrush(iris)
##D 
##D #  Now brush the points
##D 
##D pairs(iris, col=out1$col, pch=out1$pch)
##D 
##D # or
##D 
##D colhist <- function(x,...){
##D     tmp <- hist(x,plot=F)
##D     br <- tmp$breaks
##D     w <- as.numeric(cut(x,br,include.lowest=TRUE))
##D     sy <- unlist(lapply(tmp$counts,function(x)seq(length=x)))
##D     my <- max(sy)
##D     sy <- sy/my
##D     my <- 1/my
##D     sy <- sy[order(order(x))]
##D     tmp.usr <- par('usr'); on.exit(par(usr=tmp.usr))
##D     par(usr=c(tmp.usr[1:2],0,1.5))
##D     rect(br[w], sy-my, br[w+1], sy, 
##D        col=out1$col, # note out1$col is hardcoded here.
##D        border=NA)
##D     rect(br[-length(br)], 0, br[-1], tmp$counts*my)
##D }
##D pairs(iris, col=out1$col, pch=out1$pch, diag.panel=colhist)
##D 
##D # some spheres
##D 
##D s1 <- matrix(nrow=0,ncol=3)
##D 
##D while( nrow(s1) < 1000 ){
##D         tmp <- rnorm(3)
##D         if( sum(tmp^2) <= 1 ){
##D                 s1 <- rbind(s1,tmp)
##D         }
##D }
##D 
##D s2 <- matrix(rnorm(3000), ncol=3)
##D s2 <- s2/apply(s2,1,function(x) sqrt(sum(x^2)))
##D 
##D tkBrush(s1, wait=FALSE)
##D tkBrush(s2, wait=FALSE)
##D 
##D # now paint values where var 2 is close to 0 in both plots 
##D # and compare the var 1 and var 3 relationship
##D 
## End(Not run)



