### Name: simpf
### Title: Simulation of a portfolio of data
### Aliases: simpf
### Keywords: file

### ** Examples

## Portfolio where both frequency and severity models are mixed.
modelfreq <- list(dist1 = "pois",
                  par1 = list(lambda = quote(Lambda * weights)),
                  dist2 = "gamma",
                  par2 = c(shape = 2, rate = 1))
modelsev<-list(dist1 = "lnorm",
               par1 = list(meanlog = quote(Theta), sdlog = 1),
               dist2 = "norm",
               par2 = c(mean = 5, sd = 1))
data(hachemeister)
weights <- hachemeister$weights/mean(hachemeister$weights)
simpf(5, 12, modelfreq, modelsev, weights)

## Portfolio where the frequency model is mixed, but not the
## severity model.
modelsev <- list(dist1 = "lnorm", par1 = list(meanlog = 7, sd = 1))  
simpf(5, 12, modelfreq, modelsev)

## Portofolio with a severity model only and a user function for the
## simulation of claim amounts.
rpareto <- function(n, alpha, lambda) lambda * (runif(n)^(-1/alpha) - 1)
modelsev <- list(dist1 = "pareto", par1 = list(alpha = 3, lambda = 8000))
simpf(5, 12, model.freq = NULL, modelsev)



