### Name: NNCH
### Title: Nearest Neighbor Convex hull
### Aliases: NNCH print.NNCH plot.NNCH NNCH.area plot.NNCHver neighNNCH
###   plot.ngNNCH getverticesNNCH NNCH.rast
### Keywords: hplot

### ** Examples

## Not run: 
##D 
##D ## Can also be used to analyse a point pattern
##D ## For example, locations of chamois in
##D ## the Chartreuse mountains (French Alps)
##D 
##D data(chamois)
##D xy <- chamois$locs
##D 
##D ## choice of the number of neighbors
##D ## Warning: this command can be very long (more than two minutes)
##D u <- neighNNCH(xy, rangek = 5:30)
##D plot(u)
##D 
##D ## 13 and 20 neighbours seem to be a good choice
##D ## Estimates the home range levels
##D (aa <- NNCH(xy, k = 13))
##D plot(aa)
##D 
##D ## plot of the home-range size
##D plot(NNCH.area(aa))
##D 
##D ## gets the home range contour
##D cont <- getverticesNNCH(aa)
##D plot(cont)
##D 
##D ## rasterizes these contours
##D sl <- getkasc(chamois$map, "Slope")
##D mm <- NNCH.rast(cont, sl)
##D image(mm)
##D 
##D ## Note that two different sets of polygons can include
##D ## the same percentage of relocation
##D aa[[1]]$area[97:105,]
##D 
##D ## For example, the same percentage of relocations is
##D ## included within the limits of the two home ranges
##D ## (91.92 percent of the localisations) 
##D opar <- par(mfrow=c(1,2))
##D plot(aa[[1]]$polygons[[103]],
##D      poly.args = list(lwd = 2))
##D points(xy, pch = 16, cex = 0.5)
##D 
##D plot(aa[[1]]$polygons[[98]],
##D      poly.args = list(lwd = 2))
##D points(xy, pch=16, cex = 0.5)
##D par(opar)
##D ## only the left-hand plot is considered as an
##D ## home range estimation (the larger one)
##D 
## End(Not run)




