### Name: buffer
### Title: Compute Buffers
### Aliases: buffer buffer.ani buffer.line
### Keywords: spatial

### ** Examples

data(puechabon)

# locs is the data frame containing the
# relocations of wild boars monitored by radio-tracking 
locs <- puechabon$locs

# sa is the "kasc" object of maps of the study area
sa <- puechabon$kasc

# Buffer of 500 m around all relocations
bu <- buffer(locs[,4:5], sa, 500)
image(bu)

# displays all the pixels of the study area within 500 m
# of a relocation of each monitored wild boar
buani <- buffer.ani(locs[,4:5], locs[,1], sa, 500)
image(buani)

## buffer around a trajectory
data(puechcirc)
uu <- puechcirc[burst = "CH930824"]
w <- ascgen(uu[[1]][,c("x","y")], nrcol = 100)
out <- buffer.line(uu[[1]][,c("x","y")], w, 100)
image(out)
plot(uu, asc = out)




