### Name: eisera
### Title: Eigenanalysis of Selection Ratios
### Aliases: eisera print.esr scatter.esr
### Keywords: multivariate hplot

### ** Examples


###########################################################
###########################################################
###
###  Example given in Calenge and Dufour 2006 (design II)

data(squirrel)

## computation of the number of relocations in each habitat type
## from the data given by Aebischer et al. (1993).
## squirrel$locs give the percentage of relocations in each habitat
## type, and Aebischer et al. (1993) indicate that there are 30
## relocations per animal.
## We therefore compute the number of relocations in each habitat type
## using:
us <- round(30 * squirrel$locs / 100)

## Habitat availability 
av <- squirrel$studyarea

## Eigenanalysis of selection ratios
ii <- eisera(us, av, scannf = FALSE)

scatter(ii, grid = FALSE, clab = 0.7)

###########################################################
###########################################################
###
###  Example of design III

iii <- eisera(us, squirrel$mcp, scannf = FALSE)
scatter(iii, grid = FALSE, clab = 0.7)




