### Name: enfa
### Title: Ecological-Niche Factor Analysis
### Aliases: enfa hist.enfa print.enfa data2enfa print.dataenfa
### Keywords: multivariate

### ** Examples

## Not run: 
##D data(lynxjura)
##D 
##D map <- lynxjura$map
##D 
##D ## We keep only "wild" indices.
##D tmp <- lynxjura$locs[,4]!="D"
##D locs <- lynxjura$locs[tmp, c("X","Y")]
##D hist(map, type = "l")
##D ## The variable artif is far from symetric
##D 
##D ## We perform a square root transformation
##D ## of this variable
##D ## We therefore normalize the variable 'artif'
##D map[,4] <- sqrt(map[,4])
##D hist(map, type = "l")
##D 
##D ## We prepare the data for the ENFA
##D (dataenfa1 <- data2enfa(map, locs[tmp, c("X","Y")]))
##D 
##D ## We then perform the ENFA
##D (enfa1 <- enfa(dataenfa1$tab, dataenfa1$pr,
##D                scannf = FALSE))
##D hist(enfa1)
##D hist(enfa1, scores = FALSE, type = "l")
##D 
##D ## randomization test and scatterplot
##D (renfa <- randtest(enfa1))
##D plot(renfa)
##D scatter(enfa1)
## End(Not run)



