### Name: getascattr
### Title: Copy the Attributes of an Object of Class 'asc' or 'kasc' to
###   another Object
### Aliases: getascattr getkascattr
### Keywords: programming

### ** Examples

data(puechabon)

## my.map is a map of elevation
my.map <- getkasc(puechabon$kasc, "Elevation")
sl <- getkasc(puechabon$kasc, "Slope")
attributes(sl) <- NULL
sl <- matrix(sl, ncol = ncol(my.map))

## sl is a matrix with the same size as my.map
toto <- getascattr(my.map, sl)
image(toto)

## same rationale with aspect
asp <- getkasc(puechabon$kasc, "Aspect")
le <- levels(asp)
attributes(asp) <- NULL
asp <- matrix(asp, ncol = ncol(my.map))

## asp is now a matrix with the same size as my.map
tutu <- getascattr(my.map, asp, typ = "factor", lev = le)
cl <- colasc(tutu, NorthEast = "blue", SouthEast = "red", 
           SouthWest = "orange", NorthWest = "green")
image(tutu, clfac = cl)




