### Name: kernelUD
### Title: Estimation of Kernel Home-Range
### Aliases: kernelUD print.khr image.khr plotLSCV getvolumeUD kernel.area
###   getverticeshr kernelbb plot.kver
### Keywords: spatial

### ** Examples


data(puechabon)
loc <- puechabon$locs[, c("X", "Y")]
id <- puechabon$locs[, "Name"]

## Estimation of UD for the four animals
ud <- kernelUD(loc, id)
ud

image(ud) ## Note that the contours
          ## corresponds to values of probability density
udvol <- getvolumeUD(ud)
image(udvol)
## Here, the contour corresponds to the
## home ranges estimated at different probability
## levels (i.e. the contour 90 corresponds to the 90 percent
## kernel home-range)
## udvol describes, for each cell of the grid,
## the smaller home-range to which it belongs 

## Calculation of the 95 percent home range
ver <- getverticeshr(ud, 95)
elev <- getkasc(puechabon$kasc, "Elevation") # Map of the area
image(elev)
plot(ver, add=TRUE)
legend(696500, 3166000, legend = names(ver), fill = rainbow(4))

## Example of estimation using LSCV
udbis <- kernelUD(loc, id, h = "LSCV")
image(udbis)

## Compare the estimation with ad hoc and LSCV method
## for the smoothing parameter
(cuicui1 <- kernel.area(loc, id)) ## ad hoc
plot(cuicui1)
(cuicui2 <- kernel.area(loc, id, h = "LSCV")) ## LSCV
plot(cuicui2)

## Diagnostic of the cross-validation
plotLSCV(udbis)

## Use of the same4all argument: the same grid
## is used for all animals
udbis <- kernelUD(loc, id, same4all = TRUE)
image(udbis)

## And finally, estimation of the UD on a map
## (e.g. for subsequent analyses on habitat selection)
elev <- getkasc(puechabon$kasc, "Elevation")
opar <- par(mfrow = c(2, 2), mar = c(0, 0, 2, 0))
cont <- getcontour(elev)

for (i in 1:length(udbis)) {
   image(elev, main = names(udbis)[i], axes = FALSE)
   points(udbis[[i]]$locs, pch = 21, bg = "white", col = "black")
}

## Measures the UD in each pixel of the map
udbis <- kernelUD(loc, id, grid = elev)
opar <- par(mfrow = c(2, 2), mar = c(0, 0, 2, 0))
for (i in 1:length(udbis)) {
  image(udbis[[i]]$UD, main = names(udbis)[i], axes = FALSE)
  box()
  polygon(cont[, 2:3])
}
par(opar)



###############################################
###############################################
###############################################
###
###         Kernel estimation: a brownian
###               bridge approach

## Not run: 
##D 
##D ## loads the data
##D data(puechcirc)
##D 
##D ## gets one circuit
##D x <- getburst(puechcirc, burst = "CH930824")
##D 
##D ## fits the home range
##D (tata <- kernelbb(x, 10, 10, same4all = TRUE))
##D image(tata)
##D lines(x$x, x$y, lwd = 2, col = "red")
##D 
##D ## Image of a brownian bridge. Fit with two relocations:
##D fac <- factor(c("a", "a"))
##D xx <- c(0,1)
##D yy <- c(0,1)
##D date <- c(0,1)
##D class(date) <- c("POSIXt", "POSIXct")
##D tr <- as.traj(fac, data.frame(x = xx,y = yy), date)
##D 
##D ## Use of different smoothing parameters
##D sig1 <- c(0.05, 0.1, 0.2, 0.4, 0.6)
##D sig2 <- c(0.05, 0.1, 0.2, 0.5, 0.7)
##D 
##D y <- list()
##D for (i in 1:5) {
##D   for (j in 1:5) {
##D      k <- paste("s1=", sig1[i], ", s2=", sig2[j], sep = "")
##D      y[[k]]<-kernelbb(tr, sig1[i], sig2[j])[[1]]$UD
##D    }
##D  }
##D 
##D ## Displays the results
##D opar <- par(mar = c(0,0,2,0), mfrow = c(5,5))
##D foo <- function(x)
##D    {
##D      image(y[[x]], main = names(y)[x], axes = F)
##D      points(tr[,c("x","y")], pch = 16, col = "red")
##D    }
##D lapply(1:length(y), foo)
##D 
##D par(opar)
##D 
## End(Not run)



