### Name: mahasuhab
### Title: Habitat Suitability Mapping with Mahalanobis Distances.
### Aliases: mahasuhab
### Keywords: spatial multivariate

### ** Examples

## loads the data
data(lynxjura)
ka <- lynxjura$map
lo <- lynxjura$locs[,1:2]

## We first scale the maps
df <- kasc2df(ka)
pc <- dudi.pca(df$tab, scannf=FALSE)
tab <- pc$tab
ka <- df2kasc(tab, df$index, ka)

## habitat suitability mapping
hsm <- mahasuhab(ka, lo, type = "probability")
plot(hsm, main = "Habitat suitability map for the Lynx",
     plot.axes = { points(lo, pch = 16, cex=0.5)})



