### Name: mcp
### Title: Estimation of the Home Range Using the Minimum Convex Polygon
###   Estimator
### Aliases: mcp plot.hrsize mcp.area
### Keywords: hplot

### ** Examples

data(puechabon)
locs <-  puechabon$locs

cp <- mcp(locs[,4:5], locs[,1])

## Plot the home ranges
opar <- par(mar = c(0,0,0,0))
area.plot(cp)

## ... And the relocations
points(locs[,4:5], pch = 16, col = as.numeric(locs[,1]))
par(opar)

## Computation of the home-range size:
if (require(gpclib)) {
  (cuicui1 <- mcp.area(locs[,4:5], locs[,1]))
  plot(cuicui1)
}




