### Name: plot.area
### Title: Graphical Display of Objects of Class "area"
### Aliases: plot.area
### Keywords: hplot

### ** Examples


## Loading the relocations of wild boars
## monitored using radio-tracking
data(puechabon)
locs <-  puechabon$locs
el <- getkasc(puechabon$kasc, "Elevation")

## Estimation of the MCP home ranges of the animals
cp <- mcp(locs[,4:5], locs[,1])

## Use of plot.area to display the results
plot(cp)

## different colors:
color <- c("red", "blue", "green", "yellow")
lev <- levels(cp[,1])
image(el)
plot(cp, colpol = color, add = TRUE)
legend(697198, 3165529, legend = lev, fill = color)

## or:
image(el)
plot(cp, colborder = color, colpol = NA, add = TRUE)
legend(697198, 3165529, legend = lev, fill = color)

## plots one animal
image(el)
plot(cp, which = "Brock", add = TRUE)




