### Name: subsetmap
### Title: Storing a Part of a Map
### Aliases: subsetmap subsetmap.asc subsetmap.kasc
### Keywords: spatial

### ** Examples


data(puechabon)
kasc <- puechabon$kasc
el <- getkasc(kasc, "Elevation")

## limits of the new map:
xl <- c(701561, 704017)
yl <- c(3160560, 3162343)

## computation of the new map:
su <- subsetmap(el, xlim = xl, ylim = yl)

## Display
opar <- par(mar = c(0,0,0,0))
layout(matrix(c(1,1,1,1,1,1,1,1,2), byrow = TRUE, ncol = 3))
image(el, axes = FALSE)
polygon(c(xl[1], xl[2], xl[2], xl[1]),
        c(yl[1], yl[1], yl[2], yl[2]))
image(su, axes = FALSE)
box()

par(opar)
par(mfrow = c(1,1))

### Gets this part for the whole kasc object
m <- subsetmap(kasc, xlim = xl, ylim = yl)
image(m)

## Not run: 
##D  ## Interactive example 
##D  su <- subsetmap(kasc)
##D 
##D  image(su)
## End(Not run)




