### Name: bctrans
### Title: Univariate and multivariate transformations to normality
### Aliases: bctrans bctrans1 lrt.bctrans print.bctrans
### Keywords: models regression

### ** Examples

data(highway)
b <- highway[,c(8,1,2,10,5)] # select interesting columns
summary(ans <- bctrans1(b,family="yeo.johnson")) # zeros ==> use yeo.johnson
# or, compute using a formula and get the same answer.
summary(ans2 <- bctrans(~Len+ADT+Trks+Shld+Sigs,data=highway,family="yeo.johnson"))
# or, first fit an lm, and extract the formula
m1 <- lm(Rate~Len+ADT+Trks+Shld+Sigs,data=highway)
summary(ans3 <- bctrans(formula(m1),data=highway,family="yeo.johnson"))
# work with the response
b$Sigs <- (round(b$Sigs*b$Len)+1)/b$Len # redefine so no zeroes
summary(ans <- bctrans1(b)) # fit with box.cox
lrt.bctrans(ans,lrt=list(c(0,0,-1,1,0)))
plot(ans,family="power") # plot, but use ordinary powers
b <- cbind(b,powtran(ans)) # add transformed variables to data frame



