### Name: boot.case
### Title: Case bootstrap for regression models
### Aliases: boot.case boot.case.default boot.case.nls next.boot
###   next.boot.default next.boot.nls
### Keywords: regression internal

### ** Examples

data(transact)
m1 <- lm(Time~ T1 + T2, data=transact)
betahat <- coef(m1)
betahat.boot <- boot.case(m1,B=99) # 99 bootstrap samples--too small to be useful
summary(betahat.boot)  # default summary
# bootstrap standard errors 
apply(betahat.boot,2,sd)
# bootstrap 95
cl <- function(x) quantile(x,c(.025,.975))
apply(betahat.boot,2,cl)




