### Name: delta.method
### Title: Standard error of a nonlinear function of regression
###   coefficients
### Aliases: delta.method delta.method.default delta.method.nls
###   delta.method.drc compute.delta.method
### Keywords: models regression

### ** Examples

# cakes is a data frame with response Y, predictors X1 X2 
data(cakes) 
m1 <- lm(Y~ X2 + I(X2^2), data = cakes) # quadratic polynomial
delta.method(m1, "-b1/(2*b2)") # X2 that maximizes the quadratic
# second order polynomial in two predictors:
m2 <- lm(Y ~ X1 + X2 + I(X1^2) + I(X2^2) + X1:X2, data=cakes)
# Find X1 to maximize Y when X2=350:
delta.method(m2,"(b1+b5*350)/(-2*b3)")



