### Name: plot.bctrans
### Title: Plot and summary helpers for bctrans objects
### Aliases: plot.bctrans summary.bctrans coef.bctrans vcov.bctrans
### Keywords: models regression

### ** Examples

data(highway)
b <- highway[,c(8,1,2,10,5)] # select interesting columns
summary(ans <- bctrans(b,family="yeo.johnson")) # zeros ==> use yeo.johnson
b$Sigs <- (round(b$Sigs*b$Len)+1)/b$Len # redefine so no zeroes
summary(ans <- bctrans(b)) # fit with box.cox
data(highway)
b <- highway[,c(8,1,2,10,5)] # select interesting columns
summary(ans <- bctrans(b,family="yeo.johnson")) # zeros ==> use yeo.johnson
b$Sigs <- (round(b$Sigs*b$Len)+1)/b$Len # redefine so no zeroes
summary(ans <- bctrans(b)) # fit with box.cox
lrt.bctrans(ans,lrt=list(c(0,-1,1,0)))
plot(ans,family="power") # plot, but use ordinary powers
b <- cbind(b,powtran(ans)) # add transformed variables to data frame



