### Name: residual.plots
### Title: Residual plots and curvature tests for linear model fits
### Aliases: residual.plots residual.plots.lm resplot resid.curv.test
###   tukey.nonadd.test
### Keywords: hplot regression

### ** Examples

data(highway)
highway$Sigs <- (round(highway$Sigs*highway$Len)+1)/highway$Len
attach(highway)
d <- data.frame(Rate=Rate,logLen=logb(Len,2),
                logADT=logb(ADT,2),logTrks=logb(Trks,2),
                Slim=Slim,Shld=Shld,logSigs1=logb(Sigs,2))
attach(d)
m2 <- lm(Rate~logLen+logADT+logTrks+Slim+Shld+logSigs1,d)
residual.plots(m2)



