### Name: dbtrees
### Title: Download trees from internet databases.
### Aliases: dbtrees
### Keywords: manip IO

### ** Examples

if(!inherits(try(open(url("http://www.google.com")), silent = TRUE),
   "try-error")) {
## Sackin's index of a tree within TreeBASE.
sackin(dbtrees(db="treebase", tree=715, class="treeshape"))

## Colless' index of a tree within Pandit
colless(dbtrees(db="pandit", tree=1, class="treeshape"))
  
## Collects a tree without printings: 
plot(dbtrees(db="pandit", tree=709, class="treeshape", quiet=TRUE))

## Collects a list of trees :
trees=dbtrees(db="pandit", tree=1:5, class="treeshape")
summary(trees[[2]])
  
## Collects a non-binary tree
phy=dbtrees(db="pandit", tree=1, class="phylo")
plot(phy)
tree=dbtrees(db="treebase", tree=741, class="treeshape")
tree=dbtrees(db="treebase", tree=741, class="treeshape", model="yule")
plot(tree)
}



