### Name: rivGibbs
### Title: Gibbs Sampler for Linear "IV" Model
### Aliases: rivGibbs
### Keywords: models

### ** Examples

##
if(nchar(Sys.getenv("LONG_TEST")) != 0) {R=2000} else {R=10}

set.seed(66)
simIV = function(delta,beta,Sigma,n,z,w,gamma) {
eps = matrix(rnorm(2*n),ncol=2) %*% chol(Sigma)
x = z %*% delta + eps[,1]; y = beta*x +  eps[,2] + w%*%gamma
list(x=as.vector(x),y=as.vector(y)) }
n = 200 ; p=1 # number of instruments
z = cbind(rep(1,n),matrix(runif(n*p),ncol=p))
w = matrix(1,n,1)
rho=.8
Sigma = matrix(c(1,rho,rho,1),ncol=2)
delta = c(1,4); beta = .5; gamma = c(1)
simiv = simIV(delta,beta,Sigma,n,z,w,gamma)

Mcmc=list(); Prior=list(); Data = list()
Data$z = z; Data$w=w; Data$x=simiv$x; Data$y=simiv$y
Mcmc$R = R
Mcmc$keep=1
out=rivGibbs(Data=Data,Prior=Prior,Mcmc=Mcmc)

cat(" deltadraws ",fill=TRUE)
mat=apply(out$deltadraw,2,quantile,probs=c(.01,.05,.5,.95,.99))
mat=rbind(delta,mat); rownames(mat)[1]="delta"; print(mat)
cat(" betadraws ",fill=TRUE)
qout=quantile(out$betadraw,probs=c(.01,.05,.5,.95,.99))
mat=matrix(qout,ncol=1)
mat=rbind(beta,mat); rownames(mat)=c("beta",names(qout)); print(mat)
cat(" Sigma draws",fill=TRUE)
mat=apply(out$Sigmadraw,2,quantile,probs=c(.01,.05,.5,.95,.99))
mat=rbind(as.vector(Sigma),mat); rownames(mat)[1]="Sigma"; print(mat)



