### Name: rmnpGibbs
### Title: Gibbs Sampler for Multinomial Probit
### Aliases: rmnpGibbs
### Keywords: models

### ** Examples

##
if(nchar(Sys.getenv("LONG_TEST")) != 0) {R=2000} else {R=10}

set.seed(66)
p=3
n=500
beta=c(-1,1,1,2)
Sigma=matrix(c(1,.5,.5,1),ncol=2)
k=length(beta)
x1=runif(n*(p-1),min=-1,max=1); x2=runif(n*(p-1),min=-1,max=1)
I2=diag(rep(1,p-1)); xadd=rbind(I2)
for(i in 2:n) { xadd=rbind(xadd,I2)}
X=cbind(xadd,x1,x2)
simout=simmnp(X,p,500,beta,Sigma)

Data=list(p=p,y=simout$y,X=simout$X)
Mcmc=list(R=R,keep=1)

out=rmnpGibbs(Mcmc=Mcmc,Data=Data)

cat(" Betadraws ",fill=TRUE)
mat=apply(out$betadraw/sqrt(out$sigmadraw[,1]),2,quantile,probs=c(.01,.05,.5,.95,.99))
mat=rbind(beta,mat); rownames(mat)[1]="beta"; print(mat)
cat(" Sigmadraws ",fill=TRUE)
mat=apply(out$sigmadraw/out$sigmadraw[,1],2,quantile,probs=c(.01,.05,.5,.95,.99))
mat=rbind(as.vector(Sigma),mat); rownames(mat)[1]="sigma"; print(mat)




