### Name: rnegbinRw
### Title: MCMC Algorithm for Negative Binomial Regression
### Aliases: rnegbinRw
### Keywords: models

### ** Examples

##
if(nchar(Sys.getenv("LONG_TEST")) != 0)  {R=1000} else {R=10}

set.seed(66)
simnegbin = 
function(X, beta, alpha) {
#   Simulate from the Negative Binomial Regression
lambda = exp(X %*% beta)
y=NULL
for (j in 1:length(lambda))
    y = c(y,rnbinom(1,mu = lambda[j],size = alpha))
return(y)
}

nobs = 500
nvar=2            # Number of X variables
alpha = 5
Vbeta = diag(nvar)*0.01

# Construct the regdata (containing X)
simnegbindata = NULL
beta = c(0.6,0.2)
X = cbind(rep(1,nobs),rnorm(nobs,mean=2,sd=0.5))
simnegbindata = list(y=simnegbin(X,beta,alpha), X=X, beta=beta)
Data = simnegbindata
betabar = rep(0,nvar)
A = 0.01 * diag(nvar)
a = 0.5; b = 0.1
Prior = list(betabar=betabar, A=A, a=a, b=b)

keep =1
s_beta=2.93/sqrt(nvar); s_alpha=2.93
Mcmc = list(R=R, keep = keep, s_beta=s_beta, s_alpha=s_alpha)
out = rnegbinRw(Data, Prior, Mcmc)

cat(" betadraws ",fill=TRUE)
mat=apply(out$betadraw,2,quantile,probs=c(.01,.05,.5,.95,.99))
mat=rbind(beta,mat); rownames(mat)[1]="beta"; print(mat)
cat(" alphadraws ",fill=TRUE)
mat=apply(matrix(out$alphadraw),2,quantile,probs=c(.01,.05,.5,.95,.99))
mat=rbind(as.vector(alpha),mat); rownames(mat)[1]="alpha"; print(mat)    



