### Name: rscaleUsage
### Title: MCMC Algorithm for Multivariate Ordinal Data with Scale Usage
###   Heterogeneity.
### Aliases: rscaleUsage
### Keywords: models

### ** Examples

##
if(nchar(Sys.getenv("LONG_TEST")) != 0) {R=1000} else {R=5} 
{
data(customerSat)
surveydat = list(k=10,x=as.matrix(customerSat))

mcmc = list(R=R)
set.seed(66)
out=rscaleUsage(Data=surveydat,Mcmc=mcmc)

cat(" mudraws ",fill=TRUE)
mat=apply(out$mudraw,2,quantile,probs=c(.01,.05,.5,.95,.99))
print(mat)

}



