### Name: rsurGibbs
### Title: Gibbs Sampler for Seemingly Unrelated Regressions (SUR)
### Aliases: rsurGibbs
### Keywords: regression

### ** Examples

if(nchar(Sys.getenv("LONG_TEST")) != 0) {R=1000} else {R=10}
##
## simulate data from SUR
set.seed(66)
beta1=c(1,2)
beta2=c(1,-1,-2)
nobs=100
nreg=2
iota=c(rep(1,nobs))
X1=cbind(iota,runif(nobs))
X2=cbind(iota,runif(nobs),runif(nobs))
Sigma=matrix(c(.5,.2,.2,.5),ncol=2)
U=chol(Sigma)
E=matrix(rnorm(2*nobs),ncol=2)
y1=X1%*%beta1+E[,1]
y2=X2%*%beta2+E[,2]
##
## run Gibbs Sampler
regdata=NULL
regdata[[1]]=list(y=y1,X=X1)
regdata[[2]]=list(y=y2,X=X2)
Mcmc=list(R=R)
out=rsurGibbs(Data=list(regdata=regdata),Mcmc=Mcmc)
##
## summarize GS output
if(R < 100) {begin=1} else {begin=100}
end=Mcmc$R
cat(" betadraws ",fill=TRUE)
mat=apply(out$betadraw[begin:end,],2,quantile,probs=c(.01,.05,.5,.95,.99))
mat=rbind(c(beta1,beta2),mat); rownames(mat)[1]="beta"; print(mat)
cat(" Sigmadraws ",fill=TRUE)
mat=apply(out$Sigmadraw[begin:end,],2,quantile,probs=c(.01,.05,.5,.95,.99))
mat=rbind(as.vector(Sigma),mat); rownames(mat)[1]="sigma"; print(mat)



