### Name: lm.bp
### Title: General Bivariate Poisson Model
### Aliases: lm.bp
### Keywords: models regression

### ** Examples

data(ex1.sim)
# Fit Double and Bivariate Poisson models ()
#
# Model 2: DblPoisson(l1, l2)
ex1.m2<-lm.bp(x~1 , y~1 , data=ex1.sim, zeroL3=TRUE)
#
# Model 3: BivPoisson(l1, l2, l3); same as simple.bp(ex1.sim$x, ex1.sim$y)
ex1.m3<-lm.bp(x~1 , y~1 , data=ex1.sim)
# Model 4: DblPoisson (l1=Full, l2=Full) 
ex1.m4<-lm.bp(x~. , y~. , data=ex1.sim, zeroL3=TRUE)
#
# for models 4-11 maximum number of iterations is set to 2
#
# Model 5: BivPoisson(l1=full, l2=full, l3=constant)
ex1.m5<-lm.bp(x~. , y~. , data=ex1.sim, maxit=2)
# Model 6: DblPois(l1,l2)
ex1.m6<-lm.bp(x~z1 , y~z1+z5 , l1l2=~z3, data=ex1.sim, zeroL3=TRUE)
# Model 7: BivPois(l1,l2,l3=constant)
ex1.m7<-lm.bp(x~z1 , y~z1+z5 , l1l2=~z3, data=ex1.sim, maxit=2)
# Model 8: BivPoisson(l1=full, l2=full, l3=full)
ex1.m8<-lm.bp(x~. , y~. , l3=~., data=ex1.sim, maxit=2)
# Model 9: BivPoisson(l1=full, l2=full, l3=z1+z2+z3+z4)
ex1.m9<-lm.bp(x~. , y~. , l3=~.-z5, data=ex1.sim, maxit=2)
# Model 10: BivPoisson(l1, l2, l3=full)
ex1.m10<-lm.bp(x~z1 , y~z1+z5 , l1l2=~z3, l3=~., data=ex1.sim, maxit=2)
# Model 11: BivPoisson(l1, l2, l3= z1+z2+z3+z4)
ex1.m11<-lm.bp(x~z1 , y~z1+z5 , l1l2=~z3, l3=~.-z5, data=ex1.sim, maxit=2)




