### Name: boolean
### Title: Partial-Observability Binary Response Models for Testing Boolean
###   Hypotheses
### Aliases: boolean Boolean
### Keywords: logic optimize distribution models

### ** Examples

set.seed(50)
x1 <- rnorm(1000)
x2 <- rnorm(1000)
x3 <- rnorm(1000)
x4 <- rnorm(1000)
x5 <- rnorm(1000)
x6 <- rnorm(1000)
y<-1-(1-pnorm(-2+0.33*x1+0.66*x2+1*x3)*1-(pnorm(1+1.5*x4-0.25*x5)*pnorm(1+0.2*x6)))
y <- y>runif(1000)
bp <- boolprep("(a|(b&c))", "y", a = ~ x1 + x2 + x3, b = ~ x4 + x5, c = ~ x6)
answer <- boolean(bp, link = c("probit", "logit", "cloglog"), start.values = ## For speed
                  c(-1.750,  0.354,  0.698,  1.231,  1.473,  2.628, -0.452,  0.764,  0.173))

## Plot profiles
boolprof(answer)

## Examine coefficients
coef(answer)

## Examine coefficients, standard errors, etc.
summary(answer)




