### Name: mclgen
### Title: Restructure a data-frame as a "person-choice" file
### Aliases: mclgen
### Keywords: multivariate

### ** Examples

## Example 1
# data from the Data from the 1972-78 GSS used by Logan (1983)
data(logan)

# create the "person-choice" file
pc<-mclgen(logan,occ)
summary(pc)
attach(pc)

library(survival)
# The following specification will work but R won't drop
# cl.lr<-clogit(depvar~occ+occ:educ+occ:black+strata(id),data=pc)
# However, R won't drop the first category of "occ"
# in the interaction effects. The last category will be omitted
# instead due to linear dependence within strata.
# Fix for the problem, create dummies manually for "occ"
occ.X<-model.matrix(~pc$occ)
occ.X<-occ.X[,attributes(occ.X)$assign==1]
cl.lr<-clogit(depvar~occ.X+occ.X:educ+occ.X:black+strata(id),data=pc)
summary(cl.lr)

# Estimate a "quasi-uniform association" loglinear model for "focc" and "occ"
# with "educ" and "black" as covariates at the respondent level
cl.qu<-clogit(depvar~occ.X+occ.X:educ+occ.X:black+
  mob.qi(focc,occ)+mob.unif(focc,occ)+strata(id),data=pc)
summary(cl.qu)

data(housing,package="MASS")
housing.prsch<-mclgen(housing,Sat)
library(survival)
# clogit doesn't support the weights argument at present
# a work-around is to call coxph directly
# coxph warns that X is singular, because the main
# effects of Infl, Type, and Cont are dropped
coxph.prsch<-coxph(Surv(rep(1, NROW(housing.prsch)), depvar) ~
  Sat+Sat*Infl+Sat*Type+Sat*Cont+strata(id),
  weights = housing.prsch$Freq, data = housing.prsch)
summary(coxph.prsch)

# the same model using multinomial logistic regression
library(nnet)
house.mult<- multinom(Sat ~ Infl + Type + Cont, weights = Freq,
                      data = housing)
summary(house.mult,correlation=FALSE)

# compare the coefficients
m1<-coef(coxph.prsch)
m1<-m1[!is.na(m1)]
dim(m1)<-c(2,7)
m2<-coef(house.mult)
m1
m2
m1-m2
max(abs(m1-m2))
mean(abs(m1-m2))



