plot.aj              package:changeLOS              R Documentation

_P_l_o_t _f_u_n_c_t_i_o_n _f_o_r _o_b_j_e_c_t_s _o_f _c_l_a_s_s '_a_j'

_D_e_s_c_r_i_p_t_i_o_n:

     Draws a plot for an object of class 'aj' in the active graphics
     device: Transition probabilities are plotted as a function of
     time. The time origin is determined by the object of the class
     'aj'.

_U_s_a_g_e:

     plot.aj(x,
             from,
             to,
             xlab=expression(paste(Time, " ", italic(t))),
             ylab= eval(substitute(expression(paste("Estimate of ",
                        P[{a}][{b}], "(", italic(s), ",",  italic(t), ")")),
                        list(a=from[1],b=to[1],s=x$start))),
             xlim = c(x$start,max(x$times)),
             ylim=c(0,1),
             lab=c(10,10,7),
             txt=eval(substitute(expression(paste(hat(P)[{a}][{b}],
                      "(",italic(s), ",", italic(t), ")")),
                      list(a=from[1],b=to[1],s=x$start))),
             x.txt=(xlim[2]+xlim[1])/2,
             y.txt=ylim[2]*0.9,
             col=1, ...)   

_A_r_g_u_m_e_n_t_s:

       x: an object of the class 'aj'

    from: a character vector naming the states 'from'

      to: a character vector naming the states 'to'

    xlab: a title for the x axis

    ylab: a title for the y axis

    xlim: the x limits (min,max) of the plot

    ylim: the y limits (min,max) of the plot

     lab: A numerical vector of the form 'c(x, y, len)' which modifies
          the way that axes are annotated.  The values of 'x' and 'y'
          give the (approximate) number of tickmarks on the x and y
          axes and 'len' specifies the label size.

     txt: one or more character strings or expressions specifying a
          text to be written.

   x.txt: the x co-ordinates to be used to position the text

   y.txt: the y co-ordinate to be used to position the text

     col: the color of the line(s)

     ...: other graphical arguments

_V_a_l_u_e:

     A matrix with ncol = 1 + length(from): 

column 1:: vector of the timepoints, the x-cooridinates

column 2 to column ncol:: vector of the estimated transition
          probabilities, the y-coordinates

_A_u_t_h_o_r(_s):

     Matthias Wangler mw@imbi.uni-freiburg.de

_S_e_e _A_l_s_o:

     'aj'

_E_x_a_m_p_l_e_s:

     data(los.data)
     my.observ <- prepare.los.data(x=los.data)

     my.model <- msmodel(c("0","1","2","3"),cens.name="cens")
     my.trans <- trans(model=my.model,observ=my.observ)
     my.aj <- aj(my.trans, s=0, t=80)  
     plot(my.aj,c("0","0","0","0"),c("0","1","2","3"))

