### Name: clos
### Title: Change in LOS
### Aliases: clos
### Keywords: survival models

### ** Examples


## run clos
data(los.data)
my.observ <- prepare.los.data(x=los.data)
tra <- matrix(FALSE,4,4)
diag(tra) <- TRUE
tra[1,] <- TRUE
tra[2,3:4] <- TRUE
my.model <- msmodel(c("0","1","2","3"),tra,cens.name="cens")
los <- clos(model=my.model,observ=my.observ)
summary(los)
plot(los)

## expected change in LOS due to an IE
phi <- los$e.given.1 - los$e.given.0

## distinguishing between patients discharged
phi2 <- los$phi2.case - los$phi2.control
## and patients deceased
phi3 <- los$phi3.case - los$phi3.control 

## we have phi = phi2 + phi3
all(round(phi, digits=10) == round(phi2+phi3, digits=10),na.rm=TRUE)

## compute bootstrap SE with function boot() from library boot

## first we need a statistic, which boot takes as an argument
"clos.for.bstrap" <- function(data, index, mod){
  my.observ <- prepare.los.data(x=data[index,])
  return(clos(model=mod,observ=my.observ)$cLOS)
}

## our estimate is
clos.for.bstrap(data=los.data, index=1:length(los.data[,1]), mod=my.model)

## now bootstrap 
library(boot)
nb <- 20 ## nb <- 2000
los.bootstrap <- boot(los.data, clos.for.bstrap, nb, mod=my.model)
sqrt(var(los.bootstrap$t))

## compute change in LOS `by hand'; also works for alternative weights

## first, get pure event times
my.evtimes <- sort(unique(my.observ$time[my.observ$to !="cens"]))
## compute daywise difference between expected LOS
my.diffs <- los$e.given.1 - los$e.given.0
## restrict to those days when a transition out of the initial state was observed
my.diffs <- my.diffs[is.element(my.evtimes, los$w.times)]
## compute weighted average, but don't sum up over
## days where one of the groups (no) IE (yet) experienced was empty.
sum((my.diffs * los$weights)[!(is.element(los$w.times, c(los$empty.0, los$empty.1)))])




