### Name: getgiss
### Title: Retrieve station record from the GISS or NARP data set from URL.
### Aliases: getgiss getnarp
### Keywords: file

### ** Examples

## Not run: 
##D #GISS:
##D obs.oxford <- getgiss(location="Oxford")  # Takes longer time
##D stations <- getgiss()
##D obs.oxford <- getgiss(location="Oxford",stations=stations) #Quicker
##D plotStation(obs.oxford)
##D obs.broome <- getgiss(stnr="501942030004",stations=stations)
##D obs.120E.40S <- getgiss(lon=120,lat=-40,stations=stations)
##D 
##D #NARP:
##D > obs <- getnarp(4360)
##D #[1] "Retrieving the data from URL http://projects.met.no/~narp/narp"
##D #[1] "Please be patient"
##D #[1] "Found Tasilaq stnr= 4360  lon= -37.63  lat= 65.6  country= G"
##D > obs <- getnarp(lon=-37,lat=65)
##D #[1] "Retrieving the data from URL http://projects.met.no/~narp/narp"
##D #[1] "Please be patient"
##D #[1] "Find the nearest station to -37E and 65N."
##D #[1] "Found Tasilaq stnr= 4360  lon= -37.63  lat= 65.6  country= G"
##D > obs <- getnarp(lon=10,lat=60)
##D #[1] "Retrieving the data from URL http://projects.met.no/~narp/narp"
##D #[1] "Please be patient"
##D #[1] "Find the nearest station to 10E and 60N."
##D #[1] "Found Oslo stnr= 18700  lon= 10.72  lat= 59.95  country= N"
## End(Not run)



