### Name: retrieve.nc
### Title: Retrieve data from a netCDF file
### Aliases: retrieve.nc field.object fixField monthly
### Keywords: file

### ** Examples

## Not run: 
##D X.1 <- retrieve.nc("data/mpi-gsdio_t2m.nc",
##D                    x.rng=c(-60,40),y.rng=c(50,75))
##D X.2 <- retrieve.nc("data/mpi-gsdio_slp.nc",
##D                    x.rng=c(-60,40),y.rng=c(50,75))
##D 
##D # The definition of a 'field' object is:
##D ny<-length(slp$lat); nx<-length(slp$lon)
##D slp  <- list(dat=X.2$dat,lon=X.2$lon,lat=X.2$lat,tim=X.2$tim,lev=X.2$lev,
##D              v.name=X.2$v.nam,id.x=X.2$id.x,id.t=X.2$id.t,
##D              yy=X.2$yy,mm=X.2$mm,dd=X.2$dd,n.fld=1,
##D              id.lon=rep(X.2$v.name,nx),id.lat=rep(X.2$v.name,ny),
##D              attributes=dat.att)
##D  class(slp) <- c("field")
##D 
##D # For reading the IPCC FoAR netCDF files that uses a 365-day year (no leap years) and starts on time count year 0:
##D gcm <- retrieve.nc(fname,v.nam="tas",x.rng=c(-50,50),y.rng=c(30,75),forceBC=FALSE)
## End(Not run)



